/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.commands;

import java.util.Optional;
import net.skinsrestorer.api.interfaces.ISRCommandSender;
import net.skinsrestorer.api.interfaces.ISRProxyPlayer;
import net.skinsrestorer.shared.storage.Config;
import net.skinsrestorer.shared.storage.Locale;

public class CommandUtil {
    public static boolean isAllowedToExecute(ISRCommandSender sender) {
        if (Config.NOT_ALLOWED_COMMAND_SERVERS_ENABLED && sender instanceof ISRProxyPlayer) {
            Optional<String> optional = ((ISRProxyPlayer)sender).getCurrentServer();
            if (optional.isPresent()) {
                String server = optional.get();
                if (Config.NOT_ALLOWED_COMMAND_SERVERS_ALLOWLIST) {
                    if (Config.NOT_ALLOWED_COMMAND_SERVERS.contains(server)) {
                        return true;
                    }
                    sender.sendMessage(Locale.COMMAND_SERVER_NOT_ALLOWED_MESSAGE.replace("%server%", server));
                    return false;
                }
                if (Config.NOT_ALLOWED_COMMAND_SERVERS.contains(server)) {
                    sender.sendMessage(Locale.COMMAND_SERVER_NOT_ALLOWED_MESSAGE.replace("%server%", server));
                    return false;
                }
            } else {
                return !Config.NOT_ALLOWED_COMMAND_SERVERS_IF_NONE_BLOCK_COMMAND;
            }
        }
        return true;
    }
}

